<?php

class AdAgencyController extends Controller
{
	public $layout = '//layouts/column2';
	public $defaultAction = 'index';

	/**
	 * @return array action filters
	 */
	public function filters()
	{
		return array(
			'accessControl',
			'postOnly + ajaxBuyLogo, ajaxBuyCampaing'
		);
	}

	/**
	 * Specifies the access control rules.
	 * This method is used by the 'accessControl' filter.
	 * @return array access control rules
	 */
	public function accessRules()
	{
		return array(
			array('allow', // allow students only
				'actions' => array('ajaxBuyLogo', 'ajaxBuyCampaing'),
				'roles' => array('student')
			),
			array('deny', // deny all users
				'users' => array('*'),
			),
		);
	}

	public function actionAjaxBuyLogo()
	{
		header('Content-type: text/json; charset=utf-8');

		$trasaction = Yii::app()->db->beginTransaction();
		try
		{
			if (!Akcja::isAnyInteriorAllowed('intAR1r', 'intAR2r', 'intAR3r'))
				throw new Exception('Akcja zablokowana');

			$logo = filter_input(INPUT_POST, 'logo', FILTER_VALIDATE_REGEXP,
				array('options'=>array('regexp'=>'/^[a-zA-Z0-9\-_]{1,}\.[a-zA-Z0-9]{1,}$/')));
			$dziedzina = filter_input(INPUT_POST, 'dziedzina', FILTER_VALIDATE_REGEXP,
				array('options'=>array('regexp'=>'/^[a-zA-Z]{1,32}$/')));
			$agencyId = filter_input(INPUT_POST, 'agencyId', FILTER_VALIDATE_INT);
			$companyId = Yii::app()->user->id_firmy;

			$company = Firma::model()->findByPk($companyId);
			if (empty($company))
				throw new Exception('Nie posiadasz firmy.');

			$kampania = Kampanie::model()->findByAttributes(array(
				'idBudynku' => $agencyId,
				'idRodzajKampanii' => Kampanie::TYPE_LOGO
			));
			if (empty($kampania))
				throw new Exception('Agencja reklamowa nie istnieje.');

			$invoiceId = $kampania->purchaseLogo($company, $dziedzina, $logo);
			if (!$invoiceId || !$company->save(false))
				throw new Exception('Nie można wykupić loga.');

			$result['invoice'] = $invoiceId;

			Yii::app()->user->setState('logo_firmy', Yii::app()->baseUrl.'/'.$company->urlLogo);

			$trasaction->commit();
		}
		catch(Exception $e)
		{
			$result = array();
			$trasaction->rollback();
			$result['error'] = $e->getMessage();
		}

		if (Yii::app()->user->getState('bankrut'))
			$result['bankrut'] = 1;

		echo json_encode($result);
		Yii::app()->end();
	}

	public function actionAjaxBuyCampaing()
	{
		header('Content-type: text/json; charset=utf-8');

		$trasaction = Yii::app()->db->beginTransaction();
		try
		{
			if (!Akcja::isAnyInteriorAllowed('intAR1r', 'intAR2r', 'intAR3r'))
				throw new Exception('Akcja zablokowana');

			$campaingId = filter_input(INPUT_POST, 'campaingId', FILTER_VALIDATE_INT);
			$period = filter_input(INPUT_POST, 'period', FILTER_VALIDATE_INT);
			$discount = filter_input(INPUT_POST, 'discount', FILTER_VALIDATE_INT);
			$price = abs(filter_input(INPUT_POST, 'price', FILTER_VALIDATE_FLOAT));
			$companyId = (int)Yii::app()->user->id_firmy;

			$company = Firma::model()->findByPk($companyId);
			if (empty($company))
				throw new Exception('Firma nie istnieje.');

			$campaing = Kampanie::model()->with(array('rodzaj'))->find(array(
				'join' => 'left join "KampaniaFirmy" "kf" on "kf"."idKampanii" = "t"."id"
					and "kf"."idFirmy" = :companyId and "kf"."czasZakonczenia" >= sysdate',
				'condition' => '"t"."id" = :campaingId and "kf"."id" is null',
				'params' => array(
					':campaingId' => $campaingId,
					':companyId' => $companyId,
				)
			));
			if (empty($campaing))
				throw new Exception('Nie można wykupić kampanii reklamowej.');

			$result = $campaing->buy($company, $period, $discount, $price);
			$company->save(false);

			$trasaction->commit();
		}
		catch(Exception $e)
		{
			$trasaction->rollback();
			$result = array('error' => $e->getMessage());
		}

		if (Yii::app()->user->getState('bankrut'))
			$result['bankrut'] = 1;

		echo json_encode($result);
		Yii::app()->end();
	}
}
